

primitive U_FD_P_RB_SB_NO_QN (QN, D, CP, RB, SB, NOTIFIER_REG); 

    output QN;  
    input  NOTIFIER_REG,
           D, CP, RB, SB;
    reg    QN; 

// FUNCTION : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
//            ASYNCHRONOUS SET AND CLEAR . ( QN OUTPUT UDP ).


    table
 
    //  D   CP      RB  SB     NOTIFIER_REG  :   Qtn :   Qtn+1

        1   (01)    1   1         ?          :   ?   :   0;  // clocked data
        1   (01)    1   x         ?          :   ?   :   0;  // pessimism
        1    ?      1   x         ?          :   0   :   0;  // pessimism

        0    0      1   x         ?          :   0   :   0;  // pessimism
        0    x      1 (?x)        ?          :   0   :   0;  // pessimism
        0    1      1 (?x)        ?          :   0   :   0;  // pessimism

        x    0      1   x         ?          :   0   :   0;  // pessimism
        x    x      1 (?x)        ?          :   0   :   0;  // pessimism
        x    1      1 (?x)        ?          :   0   :   0;  // pessimism

        0   (01)    1   1         ?          :   ?   :   1;  // clocked data
        0   (01)    x   1         ?          :   ?   :   1;  // pessimism

        0    ?      x   1         ?          :   1   :   1;  // pessimism

        1    0      x   1         ?          :   1   :   1;  // pessimism
        1    x    (?x)  1         ?          :   1   :   1;  // pessimism
        1    1    (?x)  1         ?          :   1   :   1;  // pessimism

        x    0      x   1         ?          :   1   :   1;  // pessimism
        x    x    (?x)  1         ?          :   1   :   1;  // pessimism
        x    1    (?x)  1         ?          :   1   :   1;  // pessimism

        1   (x1)    1   1         ?          :   0   :   0;  // reducing pessimism
        0   (x1)    1   1         ?          :   1   :   1;                          
        1   (0x)    1   1         ?          :   0   :   0;  
        0   (0x)    1   1         ?          :   1   :   1;  

        ?   ?       0   1         ?          :   ?   :   1;  // asynchronous clear
        ?   ?       ?   0         ?          :   ?   :   0; 

        ?   (?0)    ?   ?         ?          :   ?   :   -;  // ignore falling clock
        ?   (1x)    ?   ?         ?          :   ?   :   -;  // ignore falling clock
        *    ?      ?   ?         ?          :   ?   :   -;  // ignore data edges 

        ?   ?     (?1)  ?         ?          :   ?   :   -;  // ignore the edges on 
        ?   ?       1  (?1)       ?          :   ?   :   -;  //       set and clear                  
        
        ?   ?       ?   ?         *          :   ?   :   x;
 
    endtable
endprimitive


